package ru.yandex.travel.api.services.hotels.legacy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import com.google.common.collect.ImmutableSet;
import lombok.AllArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import yandex.maps.proto.search.business.Business;

import ru.yandex.travel.hotels.common.Permalink;
import ru.yandex.travel.hotels.geosearch.GeoSearchService;
import ru.yandex.travel.hotels.geosearch.model.GeoHotel;
import ru.yandex.travel.hotels.geosearch.model.GeoOriginEnum;
import ru.yandex.travel.hotels.geosearch.model.GeoSearchReq;

@Component
@AllArgsConstructor
public class LegacyHotelsService {

    private final static Set<String> TOP_FEATURES = ImmutableSet.of(
            "star",
            "wi_fi",
            "pool",
            "car_park",
            "air_conditioning",
            "beach_line",
            "gym",
            "shared_kitchen",
            "pets",
            "bbq"
    );

    private final Logger logger = LoggerFactory.getLogger(LegacyHotelsService.class);
    private final GeoSearchService geoSearchService;
    private final LegacyHotelInfoProvider legacyHotelInfoProvider;

    public LegacyHotelInfo getStaticHotelInfo(long hotelId) {
        return legacyHotelInfoProvider.getHotelInfo(hotelId);
    }

    public CompletableFuture<GeoHotel> getGeoInfoByPermalink(Permalink permalink) {
        logger.info("Will try to hotel info for hotel (permalink={})", permalink);
        GeoSearchReq geoSearchReq = GeoSearchReq.byPermalink(GeoOriginEnum.LEGACYHOTEL_PAGE, permalink, null);
        geoSearchReq.setLimit(1);
        geoSearchReq.setIncludeOfferCache(true);

        return geoSearchService.query(geoSearchReq)
                .thenApply(r -> {
                    if (r.getHotels().size() != 0) {
                        return r.getHotels().get(0);
                    } else {
                        return null;
                    }
                });
    }

    public List<String> getActiveBooleanTopFeatureNames(GeoHotel hotel) {
        List<String> activeBooleanFeatureNames = new ArrayList<>();
        for (Business.Feature feature : hotel.getGeoObjectMetadata().getFeatureList()) {
            if (feature.getValue().getBooleanValue() && TOP_FEATURES.contains(feature.getId())) {
                activeBooleanFeatureNames.add(feature.getName());
            }
        }
        return activeBooleanFeatureNames;
    }
}
