package ru.yandex.travel.api.services.hotels.offercache

import ru.yandex.travel.commons.concurrent.toCompletable
import ru.yandex.travel.hotels.offercache.api.TReadReq
import ru.yandex.travel.hotels.offercache.api.TReadResp
import java.util.concurrent.CompletableFuture

open class OffercacheServiceImpl(private val offercacheClientFactory: OffercacheClientFactory) : OffercacheService {
    override fun read(request: TReadReq): CompletableFuture<TReadResp> =
        offercacheClientFactory.createRoundRobinStub().read(request).toCompletable()
}
