package ru.yandex.travel.api.services.hotels.promogranter;

import java.util.List;

import io.opentracing.Tracer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.proto.TPingRpcReq;
import ru.yandex.travel.hotels.proto.promogranter_service.PingServiceV1Grpc;
import ru.yandex.travel.orders.client.ChannelState;
import ru.yandex.travel.orders.client.GrpcServiceConfigurationBase;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;
import ru.yandex.travel.tvm.TvmWrapper;

import static ru.yandex.travel.commons.concurrent.FutureUtils.buildCompletableFuture;

@Slf4j
@Configuration
@EnableConfigurationProperties(PromoGranterProperties.class)
public class PromoGranterConfiguration extends GrpcServiceConfigurationBase {
    public PromoGranterConfiguration(PromoGranterProperties properties, Tracer tracer) {
        super(properties, tracer);
    }

    @Bean("PromoGranterGrpcChannelFactory")
    public HAGrpcChannelFactory haGrpcChannelFactory(@Autowired(required = false) TvmWrapper tvm) {
        return getGrpcChannelFactory(tvm, channel -> buildCompletableFuture(PingServiceV1Grpc
                        .newFutureStub(channel)
                        .ping(TPingRpcReq.newBuilder().build())
                ).thenApply((rsp) -> rsp.getIsReady() ? ChannelState.READY : ChannelState.NOT_READY),
                null, List.of(PingServiceV1Grpc.getPingMethod()));
    }
}
