package ru.yandex.travel.api.services.hotels.promogranter;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.commons.retry.RetryRateLimiter;
import ru.yandex.travel.commons.retry.SpeculativeRetryStrategy;
import ru.yandex.travel.hotels.proto.promogranter_service.PromoGranterServiceV1Grpc;
import ru.yandex.travel.hotels.proto.promogranter_service.TCreateAdditionalBindingReq;
import ru.yandex.travel.hotels.proto.promogranter_service.TCreateAdditionalBindingRsp;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;

import static ru.yandex.travel.commons.concurrent.FutureUtils.buildCompletableFuture;

@Slf4j
@Component
public class PromoGranterService {
    private final HAGrpcChannelFactory haGrpcChannelFactory;
    private final RetryRateLimiter rateLimiter;
    private final Retry retryHelper;

    public PromoGranterService(@Qualifier("PromoGranterGrpcChannelFactory") HAGrpcChannelFactory haGrpcChannelFactory,
                             Retry retryHelper) {
        this.haGrpcChannelFactory = haGrpcChannelFactory;
        this.rateLimiter = new RetryRateLimiter(0.3);
        this.retryHelper = retryHelper;
    }

    private PromoGranterServiceV1Grpc.PromoGranterServiceV1FutureStub getPromoGranterFutureStub() {
        return PromoGranterServiceV1Grpc.newFutureStub(haGrpcChannelFactory.getRoundRobinChannel());
    }

    public CompletableFuture<TCreateAdditionalBindingRsp> createAdditionalBinding(TCreateAdditionalBindingReq createAdditionalBindingReq, String logId) {
        return retryHelper.withSpeculativeRetry("PromoGranterService::createAdditionalBinding/" + logId,
                req -> buildCompletableFuture(getPromoGranterFutureStub().createAdditionalBinding(req)),
                createAdditionalBindingReq,
                SpeculativeRetryStrategy.<TCreateAdditionalBindingRsp>builder()
                        .shouldRetryOnException(e -> true)
                        .validateResult(resp -> { })
                        .timeout(Duration.ofSeconds(10))
                        .retryDelay(Duration.ofSeconds(3))
                        .numRetries(5)
                        .build(),
                rateLimiter);
    }
}
