package ru.yandex.travel.api.services.hotels.redir;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "hotels-redir", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class HotelsRedirServiceProperties {
    @NotEmpty
    private String baseUrl;

    @NotNull
    private Duration httpReadTimeout = Duration.ofMillis(100);

    @NotNull
    private Duration httpRequestTimeout = Duration.ofMillis(50);

    private double retryRateLimit = 0.3;
}
