package ru.yandex.travel.api.services.hotels.serp_popular_destinations;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

@ConfigurationProperties(value = "hotel-serp-popular-destinations", ignoreUnknownFields = false)
@Getter
@Setter
public class SerpPopularDestinationsServiceProperties extends YtLuceneIndexParams {
    private boolean enabled;

    @NotNull
    private String portalPrefix;

    @NotNull
    private String title;

    @NotNull
    private Duration cacheDuration;

    @NotNull
    private String imageSize;
}
