package ru.yandex.travel.api.services.hotels.static_pages;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.travel.api.models.hotels.Badge;
import ru.yandex.travel.api.models.hotels.Hotel;
import ru.yandex.travel.api.models.hotels.HotelWithOffers;
import ru.yandex.travel.api.models.hotels.OfferCacheMetadata;
import ru.yandex.travel.api.models.hotels.Price;
import ru.yandex.travel.api.models.hotels.RegionSearchHotelsRequestData;
import ru.yandex.travel.commons.http.CommonHttpHeaders;
import ru.yandex.travel.credentials.UserCredentials;

public interface IRegionHotelSearcher {
    @Data
    @AllArgsConstructor
    class SearchResultHotel {
        private HotelWithOffers hotelWithOffers;
        private List<Badge> badges;
        private Boolean isPlusAvailable;
    }

    @Data
    @AllArgsConstructor
    class SearchResult {
        private int totalHotelsFound;
        private OfferCacheMetadata ocMeta;
        private List<SearchResultHotel> hotels;
    }
    @Data
    @AllArgsConstructor
    class HotelWithMinPrice {
        private Hotel hotel;
        private Price minPrice;
        private List<Badge> badges;
        private Boolean hasOfferYandexPlus;
    }

    @Data
    @AllArgsConstructor
    class SearchResultWithMinPrices {
        private List<RegionHotelsSearcher.HotelWithMinPrice> hotelsWithMinPrice;
        private int totalHotelsFound;
    }

    CompletableFuture<SearchResult> searchHotels(int geoId, RegionSearchHotelsRequestData requestData,
                                                 CommonHttpHeaders headers, UserCredentials userCredentials,
                                                 String logPrefix);

    CompletableFuture<SearchResultWithMinPrices> searchHotelsWithMinPrices(int geoId,
                                                                           RegionSearchHotelsRequestData requestData,
                                                                           CommonHttpHeaders headers,
                                                                           UserCredentials userCredentials,
                                                                           String logPrefix);
}
