package ru.yandex.travel.api.services.hotels.suggest;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "hotel-suggest", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class HotelSuggestServiceProperties {
    @NotEmpty
    private String baseUrl;

    @NotNull
    private Duration httpReadTimeout = Duration.ofMillis(100);

    @NotNull
    private Duration httpRequestTimeout = Duration.ofMillis(50);

    private double retryRateLimit = 0.3;
}
