package ru.yandex.travel.api.services.hotels.tugc;

import java.time.Duration;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.orders.client.FailureDetectorProperties;
import ru.yandex.travel.orders.client.GrpcChannelSupplierMode;
import ru.yandex.travel.orders.client.GrpcChannelSupplierProperties;
import ru.yandex.travel.orders.client.yp.YpDiscoveryProperties;

@Data
@Validated
@ConfigurationProperties(value = "tugc", ignoreUnknownFields = false)
public class TugcProperties implements GrpcChannelSupplierProperties {
    private List<String> targets;

    @Valid
    private YpDiscoveryProperties yp;

    @Valid
    @NotNull
    private GrpcChannelSupplierMode mode;

    @Valid
    private FailureDetectorProperties failureDetection;

    @NotNull
    private Duration timeout;

    @Positive
    private int maxMessageSize;

    private Tvm tvm;

    @Data
    @Validated
    public static class Tvm {
        private boolean enabled;

        @NotEmpty
        private String destinationAlias;
    }
}
