package ru.yandex.travel.api.services.hotels.ugc;

import NUgc.NSchema.NOrgs.OrgDigest;
import NUgc.NSchema.NOrgs.OrgReview;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import lombok.extern.slf4j.Slf4j;
import org.asynchttpclient.Response;

import ru.yandex.travel.api.services.hotels.ugc.model.UgcChangeReviewRsp;
import ru.yandex.travel.api.services.hotels.ugc.model.UgcDigestRsp;
import ru.yandex.travel.api.services.hotels.ugc.model.UgcGetCurrentUserReviewRsp;
import ru.yandex.travel.api.services.hotels.ugc.model.UgcUploadImageHttpRsp;

@Slf4j
public class UgcParser {
    private ObjectMapper mapper;

    public UgcParser(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public UgcDigestRsp parseDigestRsp(byte[] binResponse) throws InvalidProtocolBufferException {
        return new UgcDigestRsp(OrgDigest.TOrgDigest.parseFrom(binResponse));
    }

    public UgcChangeReviewRsp parseChangeReviewRsp(byte[] binResponse) throws InvalidProtocolBufferException {
        OrgReview.TOrgReview review = OrgReview.TOrgReview.parseFrom(binResponse);

        return new UgcChangeReviewRsp(review);
    }

    public UgcUploadImageHttpRsp parseUploadImageRsp(Response rsp) {
        try {
            return mapper.readValue(rsp.getResponseBody(), new TypeReference<>() {});
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public UgcGetCurrentUserReviewRsp parseGetCurrentUserReviewRsp(byte[] binResponse) throws InvalidProtocolBufferException {
        OrgReview.TOrgReview review = OrgReview.TOrgReview.parseFrom(binResponse);

        return new UgcGetCurrentUserReviewRsp(review);
    }
}
