package ru.yandex.travel.api.services.hotels.ugc

import NUgc.NSchema.NOrgs.OrgPhoto.TOrgPhoto
import NUgc.NSchema.NOrgs.OrgReview.TOrgReview
import ru.yandex.travel.api.services.hotels.ugc.model.UgcAddReviewReq
import ru.yandex.travel.api.services.hotels.ugc.model.UgcChangeReviewReq
import ru.yandex.travel.api.services.hotels.ugc.model.UgcEditReviewReq

class UgcSerializer {

    fun serializeAddReviewBody(req: UgcAddReviewReq) = serializeChangeReviewBody(req, null)

    fun serializeEditReviewBody(req: UgcEditReviewReq) = serializeChangeReviewBody(req, req.reviewId)

    private fun serializeChangeReviewBody(req: UgcChangeReviewReq, reviewId: String?): ByteArray {
        val reviewBuilder = TOrgReview.newBuilder()
            .trySetText(req.text)
            .trySetReviewId(reviewId)
            .trySetRating(req.rating)

        for (imageId in req.imageIds) {
            val photo = TOrgPhoto.newBuilder().setPhotoId(imageId).build()
            reviewBuilder.addPhotos(photo)
        }

        return reviewBuilder.build().toByteArray()
    }

    private fun TOrgReview.Builder.trySetReviewId(reviewId: String?): TOrgReview.Builder {
        reviewId?.let { this.reviewId = reviewId }

        return this
    }

    private fun TOrgReview.Builder.trySetRating(rating: Int?): TOrgReview.Builder {
        rating?.let { this.rating = rating }

        return this
    }

    private fun TOrgReview.Builder.trySetText(text: String?): TOrgReview.Builder {
        text?.let { this.text = text }

        return this
    }
}
