package ru.yandex.travel.api.services.hotels.ugc;

import java.time.Duration;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.commons.http.HttpServiceProperties;

@ConfigurationProperties(value = "ugc", ignoreUnknownFields = false)
@Data
@Validated
@EqualsAndHashCode(callSuper = true)
public class UgcServiceProperties extends HttpServiceProperties {

    @Data
    @Validated
    public static class UrlPrefixes {
        private String orgs;
        private String users;
    }

    private String tvmDestinationAlias;
    private double retryRateLimit = 0.3;
    private String appId;
    private UrlPrefixes urlPrefixes;
    private Duration uploadRequestTimeout;
    private boolean enabledTestUgc = false;
    private String testBaseUrl;

    public boolean isEnabledTestUgc() {
        return enabledTestUgc;
    }
}
