package ru.yandex.travel.api.services.hotels_booking_flow;

import java.util.Set;

import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.localization.Inflector;
import ru.yandex.travel.api.services.localization.LocalizationService;
import ru.yandex.travel.hotels.common.partners.base.exceptions.PartnerException;

@Component
@RequiredArgsConstructor
public class BedInflector {
    private final LocalizationService localizationService;
    private final Inflector inflector;

    public enum BedType {
        MAIN_BED,
        ADULT_BED,
        EXTRA_BED,
        CHILD_BED,
        EXTRA_CHILD_BED,
        CHILD_NO_BED
    }

    @SneakyThrows
    public String inflectBedPlace(BedType bedType, int number, String locale) {
        String adj;
        String extraAdj = null;
        String place;
        switch (bedType) {
            case MAIN_BED:
                adj = localizationService.getLocalizedValue("MAIN_BED", locale);
                place = localizationService.getLocalizedValue("BED", locale);
                break;
            case ADULT_BED:
                adj = localizationService.getLocalizedValue("ADULT_BED", locale);
                place = localizationService.getLocalizedValue("BED", locale);
                break;
            case EXTRA_BED:
                adj = localizationService.getLocalizedValue("EXTRA_BED", locale);
                place = localizationService.getLocalizedValue("BED", locale);
                break;
            case CHILD_BED:
                adj = localizationService.getLocalizedValue("CHILD_BED", locale);
                place = localizationService.getLocalizedValue("BED", locale);
                break;
            case EXTRA_CHILD_BED:
                adj = localizationService.getLocalizedValue("EXTRA_BED", locale);
                extraAdj = localizationService.getLocalizedValue("CHILD_BED", locale);
                place = localizationService.getLocalizedValue("BED", locale);
                break;
            case CHILD_NO_BED:
                if (number > 1) {
                    adj = localizationService.getLocalizedValue("Children", locale);
                } else {
                    adj = localizationService.getLocalizedValue("Child", locale);
                }
                place = localizationService.getLocalizedValue("NO_BED", locale);
                break;
            default:
                throw new PartnerException("Unexpected bedding type");
        }
        String inflectedAdj;
        String inflectedPlace;
        String inflectedChildAdj = " ";
        String inflectedNumber = String.valueOf(number);
        if (number % 10 == 1 && number % 100 != 11) {
            if (bedType == BedType.CHILD_NO_BED) {
                inflectedAdj = inflector.inflect(adj, "ед,им");
            } else {
                inflectedAdj = inflector.inflect(adj, "ед,вин");
            }
            if (extraAdj != null) {
                inflectedChildAdj = String.format(" %s ", inflector.inflect(extraAdj, "ед,вин"));
            }
            if (bedType == BedType.CHILD_NO_BED) {
                inflectedPlace = inflector.inflect(place, "ед,род");
            } else {
                inflectedPlace = inflector.inflect(place, "ед,вин");
            }
        } else {
            inflectedAdj = inflector.inflect(adj, "мн,вин");
            if (extraAdj != null) {
                inflectedChildAdj = String.format(" %s ", inflector.inflect(extraAdj, "мн,вин"));
            }
            int mod = number % 10;
            if (Set.of(2, 3, 4).contains(mod) && number / 10 != 1) {
                inflectedPlace = inflector.inflect(place, "дв,род");
            } else {
                inflectedPlace = inflector.inflect(place, "мн,род");
            }
        }
        if (number <= 10) {
            if (bedType == BedType.CHILD_NO_BED) {
                inflectedNumber = inflector.inflect(localizationService.getLocalizedValue(number +
                                "Collective", locale)
                        , "муж");
            } else {
                inflectedNumber = inflector.inflect(localizationService.getLocalizedValue(String.valueOf(number),
                        locale)
                        , "сред");
            }
        }
        return String.format("%s %s%s%s", inflectedNumber, inflectedAdj, inflectedChildAdj, inflectedPlace);

    }
}
