package ru.yandex.travel.api.services.hotels_booking_flow;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import lombok.Builder;
import lombok.Data;

import ru.yandex.travel.api.endpoints.booking_flow.model.promo.AppliedPromoCampaignsDto;
import ru.yandex.travel.api.models.subscriptions.PromoSubscriptionRequestParams;
import ru.yandex.travel.api.services.hotels_booking_flow.models.OrderCreationData;
import ru.yandex.travel.commons.http.CommonHttpHeaders;
import ru.yandex.travel.credentials.UserCredentials;
import ru.yandex.travel.hotels.common.token.TravelToken;
import ru.yandex.travel.hotels.proto.THotelTestContext;
import ru.yandex.travel.hotels.proto.TOfferData;

@Data
@Builder
public class BookingFlowContext {
    private String userIp;
    private String deduplicationKey;
    private String userAgent;
    private String offerLabel;
    private String token;
    private Stage stage;
    private UserCredentials userCredentials;
    private OrderCreationData orderCreationData;
    private TravelToken decodedToken;
    private GeoSearchHotelContentService.GeoSearchFutures geoSearchFutures;
    private PartnerFutures partnerFutures;
    private PartnerBookingProvider provider;
    private PromoSubscriptionRequestParams subscriptionParams;
    private CompletableFuture<THotelTestContext> testContextFuture;
    private String paymentTestContextToken;
    private CompletableFuture<TOfferData> offerDataFuture;
    private List<String> promoCodes;
    private AppliedPromoCampaignsDto appliedPromoCampaigns;
    private Instant createdAt;
    private CommonHttpHeaders headers;

    public enum Stage {
        GET_OFFER,
        CREATE_ORDER,
        ESTIMATE_DISCOUNT
    }
}
