package ru.yandex.travel.api.services.hotels_booking_flow;

import java.time.LocalDate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.travel.hotels.models.booking_flow.SearchInfo;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Value
@AllArgsConstructor
@Builder
public class CheckParamsRequest implements CheckParamsProvider {
    private final Money priceFromPartnerOffer;
    private final Money priceBeforePromoCodes;
    private final Money priceAfterPromoCodes;
    private final LocalDate checkIn;
    private final LocalDate checkOut;
    private final EPartnerId partnerId;
    private final String hotelId;

    private final String passportId;
    private final Boolean isPlusUser;
    private final String userIp;

    public static CheckParamsRequest buildFromContext(Money priceFromPartnerOffer,
                                                      Money priceBeforePromos,
                                                      BookingFlowContext context) {
        return buildFromContext(priceFromPartnerOffer, priceBeforePromos, priceBeforePromos, context);
    }

    public static CheckParamsRequest buildFromContext(Money priceFromPartnerOffer,
                                                      Money priceBeforePromos,
                                                      Money priceAfterPromos,
                                                      BookingFlowContext context) {
        var credentials = context.getUserCredentials();
        return new CheckParamsRequest(
                priceFromPartnerOffer,
                priceBeforePromos,
                priceAfterPromos,
                context.getDecodedToken().getCheckInDate(), context.getDecodedToken().getCheckOutDate(),
                context.getDecodedToken().getPartnerId(),
                context.getDecodedToken().getOriginalId(),
                credentials.getPassportId(), credentials.isUserIsPlus(),
                credentials.getUserIp());
    }

    public static CheckParamsRequest buildFromContextAndSearchInfo(Money priceFromPartnerOffer,
                                                                   Money priceBeforePromos,
                                                                   Money priceAfterPromos,
                                                                   BookingFlowContext context,
                                                                   SearchInfo searchInfo) {
        var credentials = context.getUserCredentials();
        return new CheckParamsRequest(
                priceFromPartnerOffer,
                priceBeforePromos,
                priceAfterPromos,
                searchInfo.getCheckIn(), searchInfo.getCheckOut(),
                searchInfo.getPartnerId(), searchInfo.getOriginalId(),
                credentials.getPassportId(), credentials.isUserIsPlus(),
                credentials.getUserIp());
    }
}
