package ru.yandex.travel.api.services.hotels_booking_flow;

import java.time.Duration;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "hotels-booking-flow.providers.expedia", ignoreUnknownFields = false)
@Setter
@Getter
@Validated
public class ExpediaPartnerBookingProviderProperties {
    @NotNull
    private Duration cancellationSafetyInterval;
    @Valid
    private LegalData partnerLegalData;

    @Getter
    @Setter
    public static class LegalData {
        @NotEmpty
        private String name;
        @NotEmpty
        private String address;
        @NotEmpty
        private String registryNumber;
        @NotEmpty
        private String workingHours;

    }
}
