package ru.yandex.travel.api.services.hotels_booking_flow;


import java.time.Duration;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.schedule.PaymentScheduleProperties;

@ConfigurationProperties(value = "hotels-booking-flow.offer-service", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class OfferServiceConfigurationProperties {
    @Valid
    @NotNull
    private LegalData yandexLegalData;
    @NotNull
    private Duration tokenTtl;
    @NotNull
    @Valid
    private PaymentScheduleProperties deferredSchedule;

    @Getter
    @Setter
    public static class LegalData {
        @NotEmpty
        private String name;
        @NotEmpty
        private String address;
        @NotEmpty
        private String ogrn;
        @NotEmpty
        private String workingHours;

    }
}
