package ru.yandex.travel.api.services.hotels_booking_flow;

import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.models.booking_flow.HotelInfo;
import ru.yandex.travel.hotels.models.booking_flow.Offer;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.hotels.proto.TOfferData;
import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.commons.proto.EServiceType;

public interface PartnerBookingProvider {
    CompletableFuture<Offer> getOffer(BookingFlowContext context, Integer yandexPlusBalance);
    EServiceType getServiceType();
    EOrderType getOrderType();
    EPartnerId getPartnerId();
    boolean isPostPayAllowed(TOfferData offerData, BookingFlowContext context, HotelInfo hotelInfo);
}
