package ru.yandex.travel.api.services.hotels_booking_flow;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import ru.yandex.travel.hotels.proto.EPartnerId;


// TODO(tivelkov): this is an exact copy of PartnerDispatcher class declared in Searcher, just PartnerTaskHandler
//  is replaced with PartnerBookingService.
@Component
public class PartnerDispatcher implements ApplicationContextAware, InitializingBean {
    private ApplicationContext context;
    private Map<EPartnerId, PartnerBookingProvider> partners = new HashMap<>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void afterPropertiesSet() throws Exception {
        context.getBeansWithAnnotation(PartnerBean.class).values().forEach(o -> {
            if (!(o instanceof PartnerBookingProvider)) {
                throw new BeanInitializationException(String.format("Bean '%1$s' is not an instance of '%2$s'",
                        o.getClass().getName(),
                        AbstractPartnerBookingProvider.class.getName()));
            }
            AbstractPartnerBookingProvider h = (AbstractPartnerBookingProvider) o;
            EPartnerId key = h.getClass().getDeclaredAnnotation(PartnerBean.class).value();
            if (partners.containsKey(key)) {
                throw new BeanInitializationException(String.format(
                        "Bean '%1$s' can't handle partner '%2$s' as it is already being handled by bean '%3$s'",
                        o.getClass().getName(), key, partners.get(key).getClass().getName()));
            }
            logger.info("Registered '{}' as a handler for partner '{}'", h.getClass().getName(), key.toString());
            partners.put(key, h);
        });
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public void forEach(Consumer<? super PartnerBookingProvider> action) {
        partners.values().forEach(action);
    }

    public <T> Stream<T> map(Function<? super PartnerBookingProvider, T> action) {
        return partners.values().stream().map(action);
    }

    public PartnerBookingProvider get(EPartnerId partnerId) {
        return partners.get(partnerId);
    }

    boolean has(EPartnerId partnerId) {
        return partners.containsKey(partnerId);
    }
}
