package ru.yandex.travel.api.services.hotels_booking_flow;

import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.common.orders.HotelItinerary;
import ru.yandex.travel.hotels.common.refunds.RefundRules;
import ru.yandex.travel.hotels.models.booking_flow.LegalInfo;
import ru.yandex.travel.hotels.models.booking_flow.PartnerHotelInfo;
import ru.yandex.travel.hotels.models.booking_flow.RateInfo;
import ru.yandex.travel.hotels.models.booking_flow.RoomInfo;
import ru.yandex.travel.hotels.models.booking_flow.StayInfo;

public interface PartnerFutures {
    CompletableFuture<PartnerHotelInfo> getPartnerHotelInfo();

    CompletableFuture<RateInfo> getRateInfo();

    CompletableFuture<RoomInfo> getRoomInfo();

    CompletableFuture<StayInfo> getStayInfo();

    CompletableFuture<RefundRules> getRefundRules();

    CompletableFuture<LegalInfo.LegalInfoItem> getPartnerLegalInfoItem();

    CompletableFuture<LegalInfo.LegalInfoItem> getHotelLegalInfoItem();

    CompletableFuture<HotelItinerary> createHotelItinerary();
}
