package ru.yandex.travel.api.services.hotels_booking_flow;

import java.time.ZoneId;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.geobase.GeoBase;

@Component
@Slf4j
public class TimezoneDetector {
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.of("UTC+3");

    @Autowired
    private GeoBase geoBase;

    public ZoneId getZoneOffset(double latitude, double longitude) {
        return getZoneOffset(latitude, longitude, DEFAULT_ZONE_ID);
    }

    public ZoneId getZoneOffset(double latitude, double longitude, ZoneId defaultZoneId) {
        try {
            return ZoneId.of(geoBase.getTimezoneByLocation(latitude, longitude).getName());
        } catch (Exception ex) {
            log.error("Unable to get zoneId by coordinates, returning default", ex);
            return defaultZoneId;
        }
    }
}
