package ru.yandex.travel.api.services.hotels_booking_flow.models;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.Date;

import lombok.Getter;

public class CheckinCheckoutTime {
    @Getter
    private LocalTime begins;

    @Getter
    private LocalTime ends;

    private CheckinCheckoutTime(LocalTime begins, LocalTime ends) {
        this.begins = begins;
        this.ends = ends;
    }

    public static CheckinCheckoutTime fromString(String time) {
        return fromStrings(time, time);
    }

    public static CheckinCheckoutTime fromStrings(String begins, String ends) {
        SimpleDateFormat FORMAT_24H = new SimpleDateFormat("H:m");
        SimpleDateFormat FORMAT_12H = new SimpleDateFormat("h:m a");
        SimpleDateFormat FORMAT_24H_NO_MINUTES = new SimpleDateFormat("H");

        if (begins == null || ends ==null) {
            return null;
        }
        LocalTime beginsTime = parseMidnightMidday(begins);
        LocalTime endsTime = parseMidnightMidday(ends);
        Date beginsDate = null;
        Date endsDate = null;

        try {
            if (beginsTime == null) {
                beginsDate = FORMAT_12H.parse(begins);
            }
            if (endsTime == null) {
                endsDate = FORMAT_12H.parse(ends);
            }
        } catch (ParseException ignored1) {
            if (begins.toLowerCase().contains("am") ||
                    begins.toLowerCase().contains("pm") ||
                    ends.toLowerCase().contains("am") ||
                    ends.toLowerCase().contains("pm")) {
                return null;
            }
            try {
                if (beginsTime == null) {
                    beginsDate = FORMAT_24H.parse(begins);
                }
                if (endsTime == null) {
                    endsDate = FORMAT_24H.parse(ends);
                }
            } catch (ParseException ignored2) {
                try {
                    if (beginsTime == null) {
                        beginsDate = FORMAT_24H_NO_MINUTES.parse(begins);
                    }
                    if (endsTime == null) {
                        endsDate = FORMAT_24H_NO_MINUTES.parse(ends);
                    }
                } catch (ParseException ignored3) {
                    return null;
                }
            }
        }

        if (beginsTime == null) {
            beginsTime = LocalTime.of(beginsDate.getHours(), beginsDate.getMinutes());
        }
        if (endsTime == null) {
            endsTime = LocalTime.of(endsDate.getHours(), endsDate.getMinutes());
        }

        return new CheckinCheckoutTime(beginsTime, endsTime);
    }

    private static LocalTime parseMidnightMidday(String timeString) {
        LocalTime time = null;
        if ("полдень".equals(timeString.toLowerCase())) {
            time = LocalTime.of(12, 0);
        }
        if ("полночь".equals(timeString.toLowerCase())) {
            time = LocalTime.of(0, 0);
        }
        return time;
    }

    public boolean isOvernight() {
        return ends.equals(begins) || ends.isBefore(begins);
    }


}
