package ru.yandex.travel.api.services.hotels_booking_flow.models;

import java.time.LocalDateTime;
import java.util.UUID;

import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.api.endpoints.booking_flow.model.OrderGuestInfoDto;
import ru.yandex.travel.api.endpoints.booking_flow.model.OrderPriceInfo;
import ru.yandex.travel.api.endpoints.booking_flow.model.OrderStatus;
import ru.yandex.travel.hotels.common.orders.CancellationDetails;
import ru.yandex.travel.hotels.common.orders.promo.AppliedPromoCampaigns;
import ru.yandex.travel.hotels.models.booking_flow.Offer;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

/**
 * DTO for {@link ru.yandex.travel.orders.proto.TOrderInfo}
 */
@Value
@Builder
public class HotelOrder {
    private UUID id;
    private String prettyId;
    private Offer offerInfo;
    private OrderGuestInfoDto guestInfo;
    private LocalDateTime createdAt;
    private OrderStatus status;
    private EDisplayOrderState displayState;
    private PaymentInfo payment;
    private String confirmationId;
    private String documentUrl;
    private String businessTripDocUrl;
    private Boolean canGenerateBusinessTripDoc;
    private RefundInfo refundInfo;
    private CancellationDetails orderCancellationDetails;
    private OrderPriceInfo orderPriceInfo;
    private AppliedPromoCampaigns appliedPromoCampaigns;
}
