package ru.yandex.travel.api.services.hotels_booking_flow.models;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.api.endpoints.booking_flow.model.Guest;

@Value
@Validated
@Builder(toBuilder = true)
@JsonDeserialize(builder = OrderCreationData.OrderCreationDataBuilder.class)
public class OrderCreationData {
    private String customerEmail;
    private String customerPhone;
    private String customerIp;
    private String customerUserAgent;
    private boolean allowsSubscription;
    private List<Guest> guests;
    private String token;
    private String label;
    private String checksum;
    private String deduplicationKey;
    private int selectedBedGroupIndex;
    private boolean useDeferredPayments;
    private boolean usePostPay;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OrderCreationDataBuilder {
    }
}
