package ru.yandex.travel.api.services.hotels_booking_flow.models;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = OrderGuestInfo.OrderRequestInfoBuilder.class)
public class OrderGuestInfo {
    private String customerEmail;
    private String customerPhone;
    private boolean allowsSubscription;

    private List<HotelGuest> guests;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OrderRequestInfoBuilder {
    }
}
