package ru.yandex.travel.api.services.hotels_booking_flow.promo;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "promo-campaigns", ignoreUnknownFields = false)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Validated
public class HotelPromoCampaignsServiceProperties {
    @NotNull
    @Valid
    private Taxi2020PromoCampaignProperties taxi2020;

    @NotNull
    @Valid
    private MirApiProperties mir2020;

    @NotNull
    private Boolean yandexPlusEnabled;
    @NotNull
    private Boolean yandexPlusWithdrawEnabled;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @Validated
    public static class Taxi2020PromoCampaignProperties {
        @NotEmpty
        private String minPriceCurrency;
        @NotNull
        private BigDecimal minPriceAmount;
        @NotNull
        private Instant startsAt;
        @NotNull
        private Instant endsAt;
        @NotNull
        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
        private LocalDate maxCheckInDate;
    }
}
