package ru.yandex.travel.api.services.idm

import ru.yandex.travel.api.services.idm.model.IdmInfoRole
import ru.yandex.travel.api.services.idm.model.IdmResult
import ru.yandex.travel.api.services.idm.model.LocalizedName
import ru.yandex.travel.api.services.idm.model.ServiceUserRole
import java.util.concurrent.CompletableFuture

/*
Implementers of IdmServiceBinding interface are automatically discovered by IdmServiceGateway
 */
interface IdmServiceBinding {
    val serviceKey: String
    val serviceName: LocalizedName

    fun rolesInfo(): CompletableFuture<Map<String, IdmInfoRole>>
    fun addRole(login: String, role: String, passportUid: String?, fields: Map<String, Any>?): CompletableFuture<IdmResult>
    fun removeRole(login: String, role: String): CompletableFuture<IdmResult>
    fun getAllRoles(): CompletableFuture<List<ServiceUserRole>>
}
