package ru.yandex.travel.api.services.idm.model

import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
data class IdmField(
    val slug: String,
    val name: LocalizedName,
    val type: FieldType,
    val required: Boolean,
    val options: FieldOptions? = null,
) {
    companion object {
        fun passport(): IdmField {
            return IdmField(
                "passport-login", name = LocalizedName("Паспортный логин", "Passport login"),
                type = FieldType.PASSPORT_LOGIN, required = true
            )
        }
    }
}
