package ru.yandex.travel.api.services.localization;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class Inflector implements DisposableBean {
    static {
        System.loadLibrary("inflector_lib_java");
    }

    private long nativeHandle;

    public Inflector() {
        initialize();
    }

    public native void initialize();

    public native void dispose();

    public native String inflect(String initial, String gram) throws InflectorException;

    @Override
    public void destroy() throws Exception {
        dispose();
    }
}
