package ru.yandex.travel.api.services.orders;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum OrderListSource {
    ORCHESTRATOR("orchestrator"), TRAIN_API("train_api");

    private final String value;

    public static OrderListSource fromString(String val) {
        for (OrderListSource candidate : OrderListSource.values()) {
            if (candidate.value.equals(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(String.format("Don't know how to map %s to OrderListSource value", val));
    }
}
