package ru.yandex.travel.api.services.orders;

import java.util.Map;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;


@RequiredArgsConstructor
public enum OrderType {
    HOTEL(EDisplayOrderType.DT_HOTEL),
    TRAIN(EDisplayOrderType.DT_TRAIN),
    AVIA(EDisplayOrderType.DT_AVIA),
    BUS(EDisplayOrderType.DT_BUS);

    private static final Map<EDisplayOrderType, OrderType> PROTO_TO_ENUM_MAPPING = Map.of(
            EDisplayOrderType.DT_AVIA, OrderType.AVIA,
            EDisplayOrderType.DT_HOTEL, OrderType.HOTEL,
            EDisplayOrderType.DT_TRAIN, OrderType.TRAIN,
            EDisplayOrderType.DT_BUS, OrderType.BUS
    );

    private static final Map<String, OrderType> STRING_TO_ENUM_MAPPING = Map.of(
            "AVIA", OrderType.AVIA,
            "HOTEL", OrderType.HOTEL,
            "TRAIN", OrderType.TRAIN,
            "BUS", OrderType.BUS
    );

    @Getter
    private final EDisplayOrderType orderCommonType;

    public static OrderType fromProto(EDisplayOrderType orderType) {
        OrderType result = PROTO_TO_ENUM_MAPPING.get(orderType);
        if (result == null) {
            throw new RuntimeException(String.format("Couldn't map %s to OrderType", orderType));
        }
        return result;
    }

    public static OrderType fromString(String orderType) {
        OrderType result = STRING_TO_ENUM_MAPPING.get(orderType);
        if (result == null) {
            throw new RuntimeException(String.format("Couldn't map %s to OrderType", orderType));
        }
        return result;
    }
}
