package ru.yandex.travel.api.services.orders;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "train-orders", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class TrainOrdersServiceProperties {
    @NotNull
    private Duration afterDepartureMaxWarningTime;
    @NotNull
    private Duration electronicRegistrationChangeWarningTime;
    @NotNull
    private Duration insuranceAutoReturnWarningTime;
    @NotNull
    private Duration downloadBlankDuration;
    @NotNull
    private Duration getActualizedOrderInfoDuration;

    private boolean aggregateStatusEnabled;
}
