package ru.yandex.travel.api.services.orders.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;


/**
 * This enum is required so we can distinguish between different sources of train orders
 * It has a subset of types that correspond to EOrderType
 */

@RequiredArgsConstructor
public enum AuthorizationOrderType {
    OT_HOTEL_EXPEDIA("OT_HOTEL_EXPEDIA"),
    OT_AVIA_AEROFLOT("OT_AVIA_AEROFLOT"),
    OT_TRAIN("OT_TRAIN"),
    OT_BUS("OT_BUS"),
    OT_TRAIN_ORCH("OT_TRAIN_ORCH"),
    OT_GENERIC("OT_GENERIC");

    private final String value;


    @JsonCreator
    public static AuthorizationOrderType fromString(String value) {
        for (AuthorizationOrderType candidate : AuthorizationOrderType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown order type %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
