package ru.yandex.travel.api.services.orders.authorization;

import java.util.List;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;
import ru.yandex.travel.orders.proto.AuthorizationInterfaceV1Grpc;

@Configuration
public class AuthorizationServiceConfiguration {
    @Bean
    public AuthorizationClientFactory authorizationClientFactory(@Qualifier("OrchestratorGrpcChannelFactory") HAGrpcChannelFactory haGrpcChannelFactory) {
        return new AuthorizationClientFactory() {
            @Override
            public AuthorizationInterfaceV1Grpc.AuthorizationInterfaceV1FutureStub createFutureStub() {
                return AuthorizationInterfaceV1Grpc.newFutureStub(haGrpcChannelFactory.getAnyChannel());
            }
        };
    }

    @Bean
    public AuthorizationService authorizationService(AuthorizationClientFactory authClientFactory,
                                                     OrchestratorOrderDigestProvider orchestratorOrderDigestProvider,
                                                     TrainsOrderDigestProvider trainsOrderDigestProvider,
                                                     Retry retryHelper) {
        return new AuthorizationService(
                authClientFactory,
                List.of(orchestratorOrderDigestProvider, trainsOrderDigestProvider),
                retryHelper
        );
    }
}
