package ru.yandex.travel.api.services.orders.authorization;

import java.security.MessageDigest;

import lombok.Data;

import ru.yandex.travel.commons.crypto.HashingUtils;
import ru.yandex.travel.credentials.UserCredentials;

@Data
public class OrderDigest {
    private String prettyId;
    private String orderId;
    private String ownerPassportId;
    private AuthorizationOrderType type;
    private String emailHash;
    private String phoneHash;

    public boolean matchesOwner(UserCredentials credentials) {
        if (ownerPassportId == null || credentials == null || !credentials.isLoggedIn()) {
            return false;
        } else {
            return MessageDigest.isEqual(ownerPassportId.getBytes(), credentials.getPassportId().getBytes());
        }
    }

    public boolean matchesSecret(String secret) {
        String secretPhone = HashingUtils.hashPhone(secret);
        String secretEmail = HashingUtils.hashEmail(secret);
        boolean matchesAsPhone = MessageDigest.isEqual(secretPhone.getBytes(), phoneHash.getBytes());
        boolean matchesAsEmail = MessageDigest.isEqual(secretEmail.getBytes(), emailHash.getBytes());
        return matchesAsPhone || matchesAsEmail;
    }
}
