package ru.yandex.travel.api.services.orders.authorization;


import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.travel.api.services.train.TrainApiProxy;
import ru.yandex.travel.api.services.train.TrainProxyAuthDataResponseDTO;
import ru.yandex.travel.commons.crypto.HashingUtils;

@Service
@RequiredArgsConstructor
public class TrainsOrderDigestProvider implements OrderDigestProvider {
    private final TrainApiProxy trainApi;

    @Override
    public CompletableFuture<OrderDigest> getByPrettyId(String prettyId) {
        return trainApi.getTrainOrder(null, prettyId).thenApply(this::buildDigest).exceptionally(e -> null);
    }

    @Override
    public CompletableFuture<OrderDigest> getByOrderId(String orderId) {
        return trainApi.getTrainOrder(orderId, null).thenApply(this::buildDigest).exceptionally(e -> null);
    }

    private OrderDigest buildDigest(TrainProxyAuthDataResponseDTO res) {
        var digest = new OrderDigest();
        digest.setPrettyId(res.getResult().getExpressOrderNumber());
        digest.setOrderId(res.getResult().getTrainOrderUid());
        digest.setEmailHash(HashingUtils.hashEmail(res.getResult().getEmail()));
        digest.setPhoneHash(HashingUtils.hashPhone(res.getResult().getPhone()));
        digest.setType(AuthorizationOrderType.OT_TRAIN);
        if (StringUtils.isNotBlank(res.getResult().getPassportId())) {
            digest.setOwnerPassportId(res.getResult().getPassportId());
        }
        return digest;
    }


}
