package ru.yandex.travel.api.services.orders.happy_page;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import com.google.common.base.Strings;
import org.javamoney.moneta.Money;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.services.orders.happy_page.afisha.model.AfishaActualEventsResponse;
import ru.yandex.travel.api.services.orders.happy_page.model.AfishaCrossSalePayload;
import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

@Service
public class AfishaResponseMapper {
    public List<AfishaCrossSalePayload.EventInfo> getEventsFromResponse(String baseUrl, String formattedReqDate, AfishaActualEventsResponse response) {
        List<AfishaCrossSalePayload.EventInfo> events = new ArrayList<>();
        for (var item : response.getItems()) {
            AfishaActualEventsResponse.EventInfo event = item.getEvent();
            AfishaActualEventsResponse.ScheduleInfo scheduleInfo = item.getScheduleInfo();
            AfishaCrossSalePayload.EventInfo eventInfo = new AfishaCrossSalePayload.EventInfo();
            eventInfo.setName(event.getTitle());
            eventInfo.setType(event.getType().getName());
            if (scheduleInfo != null) {
                if (scheduleInfo.getRegularity() != null && scheduleInfo.getRegularity().getSingleShowTime() != null) {
                    eventInfo.setDateTime(scheduleInfo.getRegularity().getSingleShowTime());
                }
                if (scheduleInfo.getPreview() != null && !Strings.isNullOrEmpty(scheduleInfo.getPreview().getText())) {
                    eventInfo.setDateText(scheduleInfo.getPreview().getText());
                } else if (!Strings.isNullOrEmpty(scheduleInfo.getCollapsedText())) {
                    eventInfo.setDateText(scheduleInfo.getCollapsedText());
                }
            }
            eventInfo.setMinPrice(event.getTickets().stream()
                    .map(ticketsInfo -> {
                        if (ticketsInfo != null && ticketsInfo.getMinPrice() != null && ticketsInfo.getMinPrice().getValue() != null) {
                            return Money.of(BigDecimal.valueOf(ticketsInfo.getMinPrice().getValue().longValue(), 2),
                                    ProtoCurrencyUnit.RUB);
                        } else {
                            return null;
                        }
                    })
                    .filter(Objects::nonNull)
                    .min(Comparator.comparing(Money::getNumber))
                    .orElse(null));
            eventInfo.setTags(event.getTags().stream().map(AfishaActualEventsResponse.TagInfo::getName).collect(Collectors.toUnmodifiableList()));
            eventInfo.setEventUrl(baseUrl + event.getUrl() + "?schedule-date=" + formattedReqDate);
            if (event.getImage() != null && event.getImage().getImage() != null) {
                eventInfo.setImageUrl(event.getImage().getImage().getUrl());
            }
            events.add(eventInfo);
        }

        return events;
    }
}
