package ru.yandex.travel.api.services.orders.happy_page;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.api.services.orders.OrderType;
import ru.yandex.travel.api.services.orders.happy_page.model.CrossSaleBlockType;

@Data
@Validated
@ConfigurationProperties(value = "happy-page")
public class HappyPageProperties {
    @NotNull
    private Duration loadBlockTimeout;
    @NotNull
    private Map<OrderType, List<BlockSettings>> pageSchemas;
    @NotNull
    private List<PromoCodeSettings> promoCodes;

    @Data
    public static class BlockSettings {
        private CrossSaleBlockType type;
        private int order;
        private String promoAdFoxId;
        private boolean promoEnabled;
        private int resultsLimit;
        private String marketWidgetName;
    }

    @Data
    @Validated
    public static class PromoCodeSettings {
        @NotEmpty
        private String name;
        private OrderType forOrderType;
        private int discountAmount;
        private int minOrderPrice;
        @NotNull
        private Instant validTill;
        @NotNull
        private Instant showFrom;
        @NotNull
        private Instant showTill;
    }
}
