package ru.yandex.travel.api.services.orders.happy_page;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Strings;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.services.orders.happy_page.izi_travel.model.IziTravelSearchResponse;
import ru.yandex.travel.api.services.orders.happy_page.model.IziTravelCrossSalePayload;

@Service
public class IziTravelResponseMapper {
    public List<IziTravelCrossSalePayload.TourInfo> getToursFromResponse (String baseUrl, List<IziTravelSearchResponse> response) {
        List<IziTravelCrossSalePayload.TourInfo> tours = new ArrayList<>(response.size());
        for (IziTravelSearchResponse tourInfo : response) {
            IziTravelCrossSalePayload.TourInfo tour = new IziTravelCrossSalePayload.TourInfo();
            if (tourInfo.getImages() != null && tourInfo.getImages().size() > 0) {
                tour.setImageUrl(tourInfo.getImages().get(0).getUrl());
            } else {
                continue;
            }
            tour.setName(tourInfo.getTitle());
            tour.setTourUrl(baseUrl + "/browse/" + tourInfo.getUuid().toString());
            tour.setType(tourInfo.getType());
            if (!Strings.isNullOrEmpty(tourInfo.getCategory())) {
                tour.setCategory(tourInfo.getCategory());
            }
            if (tourInfo.getDuration() != null) {
                tour.setDuration(tourInfo.getDuration());
            }
            tours.add(tour);
        }
        return tours;
    }
}
