package ru.yandex.travel.api.services.orders.happy_page;

import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@Validated
@ConfigurationProperties(value = "market-widget")
public class MarketWidgetProperties {
    private Map<String, MarketWidgetSettings> marketWidgetSettings;

    // https://yandex.ru/support/market-distr/widgets/widgets-code.html#code
    @Data
    public static class MarketWidgetSettings {
        @NotNull
        private String title;
        @NotNull
        private String type;
        @NotNull
        private Boolean fallback;
        @NotNull
        private MarketWidgetParameters params;
        private MarketWidgetFilters filters;
    }

    @Data
    public static class MarketWidgetFilters {
        private Integer regionGeoId;
        private Integer countryGeoId;
    }

    @Data
    public static class MarketWidgetParameters {
        @NotNull
        private Integer clid;
        @NotNull
        private Integer themeId;
        private List<Integer> searchModelIds;
        private String buttonLinkType;
        private Integer themeRows;
        private Integer metrikaCounterId;
    }
}
