package ru.yandex.travel.api.services.orders.happy_page;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;

import ru.yandex.avia.booking.service.dto.FlightDTO;
import ru.yandex.avia.booking.service.dto.SegmentDTO;
import ru.yandex.travel.api.services.orders.happy_page.model.AviaHappyPageOrder;

@RequiredArgsConstructor
public class OrderFlightsExtractor {
    public static FlightDTO getFinalFlightFromForwardSegment(AviaHappyPageOrder aviaOrder) {
        SegmentDTO forwardSegment = aviaOrder.getAirReservation().getSegments().get(0); // segments should be sorted
        return forwardSegment.getFlights().get(forwardSegment.getFlights().size() - 1); //flights should be sorted too
    }

    public static FlightDTO getFirstFlightFromBackwardSegment(AviaHappyPageOrder aviaOrder) {
        Preconditions.checkState(aviaOrder.getAirReservation().getSegments().size() == 2,
                "backward segment exists only on there-and-back reservations");
        SegmentDTO backSegment = aviaOrder.getAirReservation().getSegments().get(1); // segments should be sorted
        return backSegment.getFlights().get(0); // flights should be sorted too
    }
}
