package ru.yandex.travel.api.services.orders.happy_page;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotServicePayload;
import ru.yandex.avia.booking.service.dto.OrderDTO;
import ru.yandex.travel.api.endpoints.booking_flow.DtoMapper;
import ru.yandex.travel.api.endpoints.generic_booking_flow.req_rsp.GetGenericOrderRspV1;
import ru.yandex.travel.api.endpoints.trains_booking_flow.req_rsp.OrderInfoRspV1;
import ru.yandex.travel.api.services.avia.orders.AviaOrchestratorModelConverter;
import ru.yandex.travel.api.services.hotels_booking_flow.HotelOrdersService;
import ru.yandex.travel.api.services.orders.GenericModelMapService;
import ru.yandex.travel.api.services.orders.OrderType;
import ru.yandex.travel.api.services.orders.TrainModelMapService;
import ru.yandex.travel.api.services.orders.happy_page.model.BusHappyPageOrder;
import ru.yandex.travel.api.services.orders.happy_page.model.HappyPageOrder;
import ru.yandex.travel.api.services.orders.happy_page.model.TrainHappyPageOrder;
import ru.yandex.travel.orders.proto.TGetOrderInfoRsp;
import ru.yandex.travel.orders.proto.TOrderInfo;

@Service
@RequiredArgsConstructor
public class OrderFromProtoMapper {
    private final HappyPageMapper mapper;
    private final HotelOrdersService hotelOrdersService;
    private final DtoMapper dtoMapper;
    private final AviaOrchestratorModelConverter aviaOrchestratorModelConverter;
    private final TrainModelMapService trainModelMapService;
    private final GenericModelMapService genericModelMapService;

    public HappyPageOrder map(TGetOrderInfoRsp protoRsp, boolean fillDocumentUrl) {
        TOrderInfo protoResult = protoRsp.getResult();
        return map(protoResult, fillDocumentUrl);
    }

    public HappyPageOrder map(TOrderInfo protoResult, boolean fillDocumentUrl) {
        OrderType type = OrderType.fromProto(protoResult.getDisplayOrderType());
        switch (type) {
            case HOTEL:
                var hotelOrder = hotelOrdersService.getOrderFromProto(protoResult);
                return mapper.mapHotelOrder(dtoMapper.buildOrderDto(hotelOrder, fillDocumentUrl));
            case AVIA:
                OrderDTO orderDTO = aviaOrchestratorModelConverter.fromProto(protoResult, AeroflotServicePayload.class);
                return mapper.mapOrderDto(orderDTO);
            case TRAIN:
                OrderInfoRspV1 legacyOrder = trainModelMapService.convert(protoResult, true);
                GetGenericOrderRspV1 genericOrder = genericModelMapService.getOrderFromInfo(protoResult);
                TrainHappyPageOrder trainHpOrder = mapper.mapTrainModel(legacyOrder);
                return trainHpOrder.toBuilder()
                        .services(genericOrder.getServices())
                        .build();
            case BUS:
                GetGenericOrderRspV1 busGenericOrder = genericModelMapService.getOrderFromInfo(protoResult);
                BusHappyPageOrder busHpOrder = mapper.mapBusOrder(busGenericOrder);
                return busHpOrder.toBuilder().build();
            default:
                throw new IllegalArgumentException(String.format("Cannot map info for %s order type", type));
        }
    }
}
