package ru.yandex.travel.api.services.orders.happy_page;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.avia.booking.service.dto.FlightDTO;
import ru.yandex.travel.api.services.dictionaries.avia.AviaAirportDictionary;
import ru.yandex.travel.api.services.dictionaries.avia.AviaSettlementDictionary;
import ru.yandex.travel.api.services.hotels.geobase.GeoBase;
import ru.yandex.travel.api.services.hotels.geobase.GeoBaseHelpers;
import ru.yandex.travel.api.services.orders.happy_page.model.AviaHappyPageOrder;
import ru.yandex.travel.api.services.orders.happy_page.model.HappyPageOrder;
import ru.yandex.travel.api.services.orders.happy_page.model.HotelHappyPageOrder;
import ru.yandex.travel.api.services.orders.happy_page.model.TrainHappyPageOrder;

@Service
@RequiredArgsConstructor
public class OrderGeoIDExtractor {
    private final GeoBase geoBase;
    private final AviaAirportDictionary airportDictionary;
    private final AviaSettlementDictionary aviaSettlementDictionary;

    public int extract(HappyPageOrder order) {
        if (order instanceof AviaHappyPageOrder) {
            var aviaOrder = (AviaHappyPageOrder) order;
            FlightDTO finalFlight = OrderFlightsExtractor.getFinalFlightFromForwardSegment(aviaOrder);
            long settlementId = airportDictionary.getById(finalFlight.getTo()).getSettlementId();
            return aviaSettlementDictionary.getById(settlementId).getGeoId();
        } else if (order instanceof TrainHappyPageOrder) {
            var trainOrder = (TrainHappyPageOrder) order;
            if (trainOrder.getStationTo() != null) {
                return trainOrder.getStationTo().getSettlementGeoId();
            }
        } else if (order instanceof HotelHappyPageOrder) {
            var hotelOrder = (HotelHappyPageOrder) order;
            if (hotelOrder.getOrderInfo() != null && hotelOrder.getOrderInfo().getBasicHotelInfo() != null) {
                var coordinates = hotelOrder.getOrderInfo().getBasicHotelInfo().getCoordinates();
                if (coordinates != null) {
                    int geoId = geoBase.getRegionIdByLocation(coordinates.getLatitude(), coordinates.getLongitude());
                    Integer cityGeoId = GeoBaseHelpers.getRegionRoundTo(geoBase, geoId,
                            GeoBaseHelpers.CITY_REGION_TYPE, "ru");
                    return cityGeoId == null ? 0 : cityGeoId;
                }
            }
        }
        return 0;
    }
}
