package ru.yandex.travel.api.services.orders.happy_page;

import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.services.orders.OrchestratorClientFactory;
import ru.yandex.travel.api.services.orders.happy_page.model.CrossSaleBlockType;
import ru.yandex.travel.api.services.orders.happy_page.model.HappyPageOrder;
import ru.yandex.travel.api.services.orders.happy_page.model.HotelPayload;
import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.commons.http.CommonHttpHeaders;
import ru.yandex.travel.credentials.UserCredentials;
import ru.yandex.travel.orders.proto.TGetOrderInfoReq;

@Slf4j
@Service
@RequiredArgsConstructor
public class PretripEmailService {
    private final HotelPayloadProvider hotelPayloadProvider;
    private final OrchestratorClientFactory orchestratorClientFactory;
    private final OrderFromProtoMapper orderFromProtoMapper;

    public CompletableFuture<HotelPayload> getHotelsBlock(String orderId, Integer geoId, Integer limit, CommonHttpHeaders headers, UserCredentials userCredentials) {
        TGetOrderInfoReq req = TGetOrderInfoReq.newBuilder()
                .setOrderId(orderId)
                .build();

        return FutureUtils.buildCompletableFuture(
                orchestratorClientFactory.createOrderNoAuthFutureStub().getOrderInfo(req))
                .thenApply(protoRsp -> orderFromProtoMapper.map(protoRsp, true))
                .thenCompose(order -> getHotelPayload(order, geoId, limit, headers, userCredentials));
    }

    private CompletableFuture<HotelPayload> getHotelPayload(HappyPageOrder order, Integer geoId, Integer limit,
                                                            CommonHttpHeaders headers,
                                                            UserCredentials userCredentials) {
        var blockSettings = new HappyPageProperties.BlockSettings();
        blockSettings.setType(CrossSaleBlockType.HOTEL_CROSS_SALE);
        blockSettings.setResultsLimit(limit);
        return hotelPayloadProvider
                .get(order, geoId, blockSettings, headers, userCredentials, "PreTrip")
                .exceptionally(e -> {
                    log.error("Pretrip email: Failed to get hotel payload", e);
                    return new HotelPayload();
                });
    }
}
