package ru.yandex.travel.api.services.orders.happy_page;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.services.orders.OrchestratorClientFactory;
import ru.yandex.travel.api.services.orders.notifier.model.OrderInfoPayload;
import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.orders.proto.TGetOrderInfoReq;

@Slf4j
@Service
@RequiredArgsConstructor
public class PretripOrderInfoService {
    private final OrchestratorClientFactory orchestratorClientFactory;
    private final OrderFromProtoMapper orderFromProtoMapper;
    private final OrderInfoPayloadExtractor orderInfoPayloadExtractor;

    public CompletableFuture<OrderInfoPayload> getOrderInfo(UUID orderId) {
        TGetOrderInfoReq req = TGetOrderInfoReq.newBuilder()
                .setOrderId(orderId.toString())
                .build();
        return FutureUtils.buildCompletableFuture(
                orchestratorClientFactory.createOrderNoAuthFutureStub().getOrderInfo(req))
                .thenApply(protoRsp -> orderFromProtoMapper.map(protoRsp, true))
                .thenApply(orderInfoPayloadExtractor::extract);
    }
}
