package ru.yandex.travel.api.services.orders.happy_page;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.models.hotels.Price;
import ru.yandex.travel.api.services.hotels.slug.HotelSlugService;
import ru.yandex.travel.api.services.hotels.static_pages.RegionHotelsSearcher;
import ru.yandex.travel.api.services.orders.happy_page.model.HotelPayload;

@Service
@RequiredArgsConstructor
public class RegionHotelsMapper {
    private final HotelSlugService hotelSlugService;

    public List<HotelPayload.HotelWithMinPriceBlockInfo> getHotelsWithMinPrice(
            int nights,
            RegionHotelsSearcher.SearchResultWithMinPrices searchResult
    ) {
        return searchResult.getHotelsWithMinPrice().stream()
                .map(hotel -> {
                    HotelPayload.HotelWithMinPriceBlockInfo hotelInfo = new HotelPayload.HotelWithMinPriceBlockInfo();
                    hotelInfo.setHotel(hotel.getHotel());
                    hotelInfo.setMinPrice(countMinPriceForNights(hotel.getMinPrice(), nights));
                    hotelInfo.setNights(nights);
                    hotelInfo.setBadges(hotel.getBadges());
                    hotelInfo.setLandingUrl(hotelSlugService.findMainSlugByPermalink(hotel.getHotel().getPermalink()));
                    return hotelInfo;
                }).collect(Collectors.toUnmodifiableList());
    }

    private Price countMinPriceForNights(Price minPrice, int nights) {
        if (minPrice == null) {
            return null;
        }
        Price result = new Price();
        result.setValue(minPrice.getValue() * nights);
        result.setCurrency(minPrice.getCurrency());
        return result;
    }
}
