package ru.yandex.travel.api.services.orders.happy_page.afisha;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.commons.http.apiclient.HttpApiPropertiesBase;

@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Data
@Validated
@ConfigurationProperties(value = "afisha")
public class AfishaServiceProperties extends HttpApiPropertiesBase {
    @NotEmpty
    private String tvmAlias;
    @NotNull
    private Boolean tvmEnabled;
    @NotEmpty
    private String linkBaseUrl;
}
