package ru.yandex.travel.api.services.orders.happy_page.afisha.model;

import java.time.LocalDateTime;
import java.util.List;

import lombok.Data;

@Data
public class AfishaActualEventsResponse {
    List<Item> items;

    @Data
    public static class Item {
        private ScheduleInfo scheduleInfo;
        private EventInfo event;
    }

    @Data
    public static class ScheduleInfo {
        private String collapsedText;
        private SchedulePreviewInfo preview;
        private ScheduleRegularity regularity;
    }

    @Data
    public static class SchedulePreviewInfo {
        private String text;
    }

    @Data
    public static class ScheduleRegularity {
        private LocalDateTime singleShowTime;
    }

    @Data
    public static class EventInfo {
        private String id;
        private String title;
        private String contentRating;
        private String url;
        private List<TicketsInfo> tickets;
        private TagInfo type;
        private List<TagInfo> tags;
        private ImageInfo image;
    }

    @Data
    public static class TicketsInfo {
        private PriceInfo minPrice;
    }

    @Data
    public static class PriceInfo {
        private String currency;
        private Double value;
    }

    @Data
    public static class TagInfo {
        private String name;
    }

    @Data
    public static class ImageInfo {
        private Image image;
    }

    @Data
    public static class Image {
        private String url;
    }
}
