package ru.yandex.travel.api.services.orders.happy_page.afisha.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.MultiEnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@Getter
@AllArgsConstructor
public enum AfishaImageSize implements ValueBasedEnum<String> {
    SMALL("s540x270_crop"),
    MIDDLE("s1200x628_wmark"),
    LARGE("s1920x463_crop"),
    ORIGIN("origin");

    private final String value;

    public static AfishaImageSize forValue(String value) {
        return MultiEnumIndex.getGlobal().get(AfishaImageSize.class).getByValue(value);
    }
}
