package ru.yandex.travel.api.services.orders.happy_page.izi_travel.model;

import java.util.Set;

public class IziTravelHelper {
    public static final Set<String> ALLOWED_TOUR_TYPES = Set.of("tour", "museum");
    public static final Set<String> ALLOWED_TOUR_CATEGORIES = Set.of("walk", "car");

    public static boolean checkTourTypeIsAllowed(String tourType) {
        return ALLOWED_TOUR_TYPES.contains(tourType);
    }

    public static boolean checkTourCategoryIsAllowed(String tourCategory) {
        return ALLOWED_TOUR_CATEGORIES.contains(tourCategory);
    }

    public static boolean checkCityChildIsAllowed(IziTravelCitiesChildrenResponse child) {
        return checkTourTypeIsAllowed(child.getType()) &&
                (!"tour".equals(child.getType()) || checkTourCategoryIsAllowed(child.getCategory()));
    }

    public static boolean checkSearchItemIsAllowed(IziTravelSearchResponse item) {
        return checkTourTypeIsAllowed(item.getType()) &&
                (!"tour".equals(item.getType()) || checkTourCategoryIsAllowed(item.getCategory()));
    }
}
